import React from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import ServicesForm from './ServicesForm';

const NewServices = ({ onClose, onCreateSuccess }) => {
  const handleSubmit = (formData) => {
    axios.post(`/services/`, formData)
      .then(res => {
        alert("Service created successfully!");
        if (onCreateSuccess) onCreateSuccess(res.data);
        if (onClose) onClose();
      })
      .catch(err => {
        alert("Error creating role.");
      });
  };

  return (
    <Modal title="New Service" onClose={onClose}>
      <ServicesForm onSubmit={handleSubmit} />
    </Modal>
  );
};

export default NewServices;
